//
//  GHVO2Data.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 5/22/17.
//  Copyright © 2017 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import <Foundation/Foundation.h>


/**
 *  The GHVO2Data class provides the VO2 data that was extracted from the Garmin device.
 */
@interface GHVO2Data : NSObject

/** Timestamp for the associated values. Can be null. */
@property (nullable, nonatomic, readonly) NSDate *timestamp;

/**
 * The vo2Max value. Can be null.
 * @note Values are floats.
 */
@property (nullable, nonatomic, readonly) NSNumber *vo2Max;

/**
 * The fitness age value. Can be null.
 * @note Values are integers.
 */
@property (nullable, nonatomic, readonly) NSNumber *fitnessAge;


@end
